//
//	GSSerialWin32.h
//	 1998, 1999, 2000 Kyle Hammond
//	hammo009@tc.umn.edu
//	Use at your own risk.  All rights reserved.  Do not distribute without permission.
//

#if !defined( __GSSerialWin32_h_ )
#define __GSSerialWin32_h_	1

#if !defined( __GSXSerialCommunicator_h_ )
	#include "GSXSerialCommunicator.h"
#endif

#if !defined( __wtypes_h__ )
	#include <wtypes.h>
#endif
#if !defined( _WINBASE_ )
	#include <winbase.h>
#endif

// Requires kernel32.lib and Advapi32.lib to be imported.

#define kGSSerialWin32BufferSize	256

class GSSerialWin32 : public GSXSerialCommunicator {
public:
	// Constructor.
	explicit GSSerialWin32( GSSerialPortInfoRecord *inPortInfo, GSXSerialPortNameRecord *inPortName, const bool inAsynchronous = false );

	virtual unsigned long	InitSerialComm( void );
	virtual unsigned long	CloseSerialComm( void );

	virtual unsigned long	SetPortOptions( const GSSerialPortInfoRecord *inPortInfo, const GSXSerialPortNameRecord *inPortName );

	virtual unsigned long	SendSerialInfo( const void *inBuffer, const unsigned long inBufferSize );
	virtual unsigned long	GetSerialInfo( void *outBuffer, unsigned long *ioCount, const long inWaitTicks );

	static short FindReadySerialPorts( GSXSerialPortNameRecordHandle *portInfo, const bool inOpenAndClose = true );

// Implementation section.
private:
	friend class GSSerialWin32AsyncHelper;

	char		mIncomingBuffer[ kGSSerialWin32BufferSize ];
	bool		mContinuousRead;
	short	mCharsInBuffer;
	HANDLE	mDeviceHandle;

	// Can't use default or copy constructors.
	GSSerialWin32( );
	GSSerialWin32( const GSSerialWin32 & );
};

#endif